% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unshiftdata.R
\name{unshiftdata}
\alias{unshiftdata}
\title{Inverse of shiftdata}
\usage{
unshiftdata(sd)
}
\arguments{
\item{sd}{A list of objects named \code{x}, \code{perm}, and \code{nshifts},
as returned by \code{shiftdata()}}
}
\value{
Array with the same values and dimensions as passed to a previous
  call to \code{shiftdata}.
}
\description{
Reverse what has been done by \code{shiftdata()}.
}
\details{
\code{unshiftdata} restores the orientation of the data that was shifted with
shiftdata. The permutation vector is given by \code{perm}, and \code{nshifts}
is the number of shifts that was returned from \code{shiftdata()}.

\code{unshiftdata} is meant to be used in tandem with \code{shiftdata}. These
functions are useful for creating functions that work along a certain
dimension, like filter, goertzel, sgolayfilt, and sosfilt. These functions
are useful for creating functions that work along a certain dimension, like
\code{\link{filter}}, \code{\link{sgolayfilt}}, and \code{\link{sosfilt}}.
}
\examples{

## create a 3x3 magic square
x <- pracma::magic(3)
## Shift the matrix x to work along the second dimension.
## The permutation vector, perm, and the number of shifts, nshifts,
## are returned along with the shifted matrix.
sd <- shiftdata(x, 2)

## Shift the matrix back to its original shape.
y <- unshiftdata(sd)

## Rearrange Array to Operate on First Nonsingleton Dimension
x <- 1:5
sd <- shiftdata(x)
y <- unshiftdata(sd)

}
\seealso{
\code{\link{shiftdata}}
}
\author{
Georgios Ouzounis, \email{ouzounis_georgios@hotmail.com}.\cr
  Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
