% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampled2continuous.R
\name{sampled2continuous}
\alias{sampled2continuous}
\title{Signal reconstruction}
\usage{
sampled2continuous(xn, fs, t)
}
\arguments{
\item{xn}{the sampled input signal, specified as a vector}

\item{fs}{sampling frequency in Hz used in collecting \code{x}, specified as
a positive scalar value. Default: 1}

\item{t}{time points at which data is to be reconstructed, specified as a
vector relative to \code{x[0]} (not real time).}
}
\value{
Reconstructed signal x(t), returned as a vector.
}
\description{
Analog signal reconstruction from discrete samples.
}
\details{
Given a discrete signal x[n] sampled with a frequency of \code{fs} Hz, this
function reconstruct the original analog signal x(t) at time points \code{t}.
The function can be used, for instance, to calculate sampling rate effects on
aliasing.
}
\examples{
# 'analog' signal: 3 Hz cosine
t <- seq(0, 1, length.out = 100)
xt <- cos(3 * 2 * pi * t)
plot(t, xt, type = "l", xlab = "", ylab = "", ylim = c(-1, 1.2))

# 'sample' it at 4 Hz to simulate aliasing
fs <- 4
n <- ceiling(length(t) / fs)
xn <- xt[seq(ceiling(n / 2), length(t), n)]
s4 <- sampled2continuous(xn, fs, t)
lines(t, s4, col = "red")

# 'sample' it > 6 Hz to avoid aliasing
fs <- 7
n <- ceiling(length(t) / fs)
xn <- xt[seq(ceiling(n / 2), length(t), n)]
s7 <- sampled2continuous(xn, fs, t)
lines(t, s7, col = "green")
legend("topright", legend = c("original", "aliased", "non-aliased"),
  lty = 1, col = c("black", "red", "green"))


}
\author{
Muthiah Annamalai, \email{muthiah.annamalai@uta.edu}.
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
