% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cplxreal.R
\name{cplxreal}
\alias{cplxreal}
\title{Sort complex conjugate pairs and real}
\usage{
cplxreal(z, tol = 100 * .Machine$double.eps, MARGIN = 2)
}
\arguments{
\item{z}{Vector, matrix, or array of complex numbers.}

\item{tol}{Weighting factor \code{0 < tol < 1}, which determines the
tolerance of matching. Default: \code{100 * .Machine$double.eps}.}

\item{MARGIN}{Vector giving the subscripts which the function will be applied
over. E.g., for a matrix 1 indicates rows, 2 indicates columns, c(1, 2)
indicates rows and columns. Where X has named dimnames, it can be a
character vector selecting dimension names. Default: 2 (columns).}
}
\value{
A list containing two variables:
\describe{
  \item{zc}{Vector, matrix or array containing ordered complex conjugate
  pairs by increasing real parts. Only the positive imaginary complex numbers
  of each complex conjugate pair are returned.}
  \item{zr}{Vector, matrix or array containing ordered real numbers.}
}
}
\description{
Sort numbers into into complex-conjugate-valued and real-valued elements.
}
\details{
An error is signaled if some complex numbers could not be paired and if all
complex numbers are not exact conjugates (to within tol). Note that here is
no defined order for pairs with identical real parts but differing imaginary
parts.
}
\examples{
r <- cplxreal(c(1, 1 + 3i, 2 - 5i, 1-3i, 2 + 5i, 4, 3))

}
\seealso{
\code{\link{cplxpair}}
}
\author{
Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
