% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/key1.R
\name{key1}
\alias{key1}
\alias{key1.fv}
\alias{key1val.fv}
\alias{trapz.fv}
\alias{cumtrapz.fv}
\alias{is.finite.fv}
\title{Black-Solid-Curve in \link[spatstat.explore]{plot.fv}}
\usage{
key1.fv(x)

key1val.fv(x)

trapz.fv(x)

cumtrapz.fv(x)

\method{is.finite}{fv}(x)
}
\arguments{
\item{x}{an \link[spatstat.explore]{fv.object}}
}
\value{
Function \code{\link[=key1.fv]{key1.fv()}} returns a \link[base]{character} scalar.

Function \code{\link[=key1val.fv]{key1val.fv()}} returns a \link[base]{numeric} \link[base]{vector}.

Function \code{\link[=trapz.fv]{trapz.fv()}} returns a \link[base]{numeric} scalar.

Function \code{\link[=cumtrapz.fv]{cumtrapz.fv()}} returns a \link[base]{numeric} \link[base]{vector}.

Function \code{\link[=is.finite.fv]{is.finite.fv()}} returns a \link[base]{logical} \link[base]{vector}.
}
\description{
Name and value of the \emph{black solid curve} as shown in \link[spatstat.explore]{plot.fv},
i.e., the primary outcome of an \link[spatstat.explore]{fv.object}.
}
\details{
Function \code{\link[=key1.fv]{key1.fv()}} finds the name of the primary outcome
of an \link[spatstat.explore]{fv.object}.

Function \code{\link[=key1val.fv]{key1val.fv()}} finds the value of the primary outcome
of an \link[spatstat.explore]{fv.object}.

Functions \code{\link[=trapz.fv]{trapz.fv()}} and \code{\link[=cumtrapz.fv]{cumtrapz.fv()}}
obtain the (cumulative)
\link[pracma]{trapz}oidal integration of the area under the primary outcome
of a function value \link[spatstat.explore]{fv.object}.

Function \code{\link[=is.finite.fv]{is.finite.fv()}} (dispatch of S3 generic \link[base]{is.finite})
finds the \link[base]{finite},
i.e., non-\code{NA}, non-\code{NaN} and non-\code{Inf},
indices of the primary outcome of an \link[spatstat.explore]{fv.object}.
}
\examples{
library(spatstat.data)
library(spatstat.geom) # ?spatstat.geom::subset.ppp
library(spatstat.explore)

foo = function(x) {
 x |> plot()
 'Trapzoid\n' |> cat()
 x |> trapz.fv() |> print()
 '\nCumulative Trapzoid\n' |> cat()
 x |> cumtrapz.fv() |> tail() |> print()
}

# numeric mark
spruces |> Emark() |> foo()
spruces |> Vmark() |> foo()
spruces |> markcorr() |> foo()
spruces |> markvario() |> foo()

# multitype mark
(btc = subset.ppp(betacells, select = 'type'))
btc |> Gcross(i = 'off', j = 'on') |> foo()
btc |> Kcross(i = 'off', j = 'on') |> foo()
btc |> Lcross(i = 'off', j = 'on') |> foo()
btc |> Jcross(i = 'off', j = 'on') |> foo()
btc |> markconnect(i = 'off', j = 'on') |> foo()

# swedishpines |> roc.ppp(covariate = 'x') |> foo() 
# bug in devtools::check()
}
\keyword{internal}
