% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_utils.R
\name{line_creator}
\alias{line_creator}
\title{Breaks down character strings into one or several lines, and determines if it would fit into a specific height and width.}
\usage{
line_creator(
  cex_val,
  string,
  height = numeric(),
  width = numeric(),
  units = c("mm"),
  sep = "\\n"
)
}
\arguments{
\item{cex_val}{The text cex multiplier applied to the string.}

\item{string}{The character string needed to be broken down into several lines.}

\item{height}{A numeric value designating the total height of the matrix grob in mm.}

\item{width}{A numeric value designating the total width of the matrix grob in mm.}

\item{units}{millimeters}

\item{sep}{The separator within the character string which designates where a new line should start.}
}
\value{
A list containing a vector with each index equal to a line of the broken-down string, a TRUE/FALSE value indicating whether the lines will fit within equal sized rows and the widths in mm of each of the lines.
}
\description{
Breaks down character strings into one or several lines, and determines if it would fit into a specific height and width.
}
