% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/googler.R
\name{googler}
\alias{googler}
\title{googler}
\usage{
googler(query, start = NULL, count = NULL, news = NULL, tld = NULL,
  lang = NULL, exact = NULL, time = NULL, site = NULL,
  unfilter = NULL)
}
\arguments{
\item{query}{Search query.}

\item{start}{Start at the Nth result.}

\item{count}{Show N results–defaults to 10}

\item{news}{Show results from news section.}

\item{tld}{Country-specific search with top-level domain TLD, e.g., 'in' for
India.}

\item{lang}{Search for the language, e.g., 'fi' for Finnish.}

\item{exact}{Disable automatic spelling correction. Search exact keywords.}

\item{time}{Time limit search, e.g., 'h5' (5 hrs), 'd5' (5 days), 'w5' (5
weeks), 'm5' (5 months), 'y5' (5 years)}

\item{site}{Search a site using Google.}

\item{unfilter}{Do not omit similar results.}
}
\value{
A tibble data frame where each row represents one search result and
  columns contain information about each result–i.e., abstract, phrase
  matching, title, and URL.
}
\description{
Searches Google and returns information about the results.
}
\examples{
\dontrun{
## search google within past month
googler("rstats", time = "m1")

## search google news
googler_news("rstats")
}
}
