% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtm_auth.R
\name{gtm_auth}
\alias{gtm_auth}
\title{Auth for GTM Specific Properties}
\usage{
gtm_auth(email = NULL, token = NULL, sa_json = NULL)
}
\arguments{
\item{email}{The email address for the Google Account}

\item{token}{An existing Google Auth Token}

\item{sa_json}{A GCP Service Account Key in JSON format, either a string or file.}
}
\value{
Invisibly, the token that has been saved to the session
}
\description{
This function authenticates the user with Google Tag Manager
To use your own GTM API credentials, either ensure that you have set the
path to your OAuth2 API Credentials file in your 
'GAR_CLIENT_JSON' variable in your .Renviron file and then restart your 
R session or set
}
\examples{
 
 \dontrun{
 # To use the included (shared) credentials
 library(googleTagManageR)
 gtm_auth()
 
 # To useyour own GCP credentials
 Sys.setenv("GAR_CLIENT_JSON" = "location/of/file.json")
 library(googleTagManageR)
 gtm_auth()
 
 # Reauthentication - if you've already logged in
 gtm_auth(email="me@mycompany.co.uk")
 
 # Service Account Login
 gtm_auth(sa_json="my-service-account.json")
 }
 
}
\concept{login functions}
