% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subscriptions.R
\name{subscriptions_delete}
\alias{subscriptions_delete}
\title{Deletes an existing subscription.}
\usage{
subscriptions_delete(subscription)
}
\arguments{
\item{subscription}{\code{character}, \code{Subscription} Required, subscription name or instance of
a \code{Subscription} object}
}
\value{
None, called for side effects
}
\description{
All messages retained in the subscription will be immediately dropped. Calls to \code{Pull}
after deletion will return \code{NOT_FOUND}. After a subscription is deleted, a new one may
be created with the same name, but the new one has no association with the old subscription
or its topic unless the same topic is specified.
}
\seealso{
Other Subscription functions: 
\code{\link{subscriptions_ack}()},
\code{\link{subscriptions_create}()},
\code{\link{subscriptions_detach}()},
\code{\link{subscriptions_exists}()},
\code{\link{subscriptions_get}()},
\code{\link{subscriptions_list}()},
\code{\link{subscriptions_modify_ack_deadline}()},
\code{\link{subscriptions_modify_pushconf}()},
\code{\link{subscriptions_patch}()},
\code{\link{subscriptions_pull}()},
\code{\link{subscriptions_seek}()}
}
\concept{Subscription functions}
