% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-construct-tempo.R
\name{Tempo}
\alias{Tempo}
\title{Create \code{Tempo} Object}
\usage{
Tempo(tempo, unit = NULL, bar = NULL, offset = NULL, marking = NULL)
}
\arguments{
\item{tempo}{A positive number, which indicates the number of quarter
notes per minute.}

\item{unit}{Deprecated. Was used to specify the beat unit.
Please use \code{marking} instead.}

\item{bar}{Optional. A positive integer, which indicates the number of
the measure where to add the tempo. By default, it will be added at
the first measure.}

\item{offset}{Optional. A non-negative number, which indicates
the tempo's position in a measure. The default value is \code{0}.}

\item{marking}{Optional. A single character, which represents the marking
that appears on the score. See the \emph{Details} section.}
}
\value{
A list of class \code{Tempo}.
}
\description{
Create a \code{Tempo} object to represent a tempo marking.
}
\details{
The parameter \code{tempo} is used to specify the actual playback speed, while
\code{marking} to represent the marking that appears on the score.

Some examples:
\itemize{
\item \code{Tempo(50)}: the playback speed is 50 quarter notes per minute.
A marking of "quarter = 50" will be added to the score.
\item \code{Tempo(50, marking = "Adagio")}: the playback speed is 50 quarter notes
per minute, while the marking on the score is "Adagio".
\item \code{Tempo(50, marking = "Adagio half. = 20")}: the playback speed is
50 quarter notes per minute, while the marking on the score is
"Adagio half. = 20".
\item \code{Tempo(50, marking = "Adagio (quarter = 45-80)")}: you can add a speed
range and parentheses to the marking.
\item \code{Tempo(50, marking = "quarter. = quarter")}: you can also indicate
metric modulations with \code{marking}.
}
}
\examples{
# Create a tempo
tempo <- Tempo(50, marking = "Adagio (half = 25)")
tempo

# Add it to a `Music`
music <- Music() + Meter(4, 4) + Line(c("C4", "D4", "E4", "F4")) + tempo
music

# Generate the music score
if (interactive()) {
  show(music)
}
}
\seealso{
\code{\link[=+.Music]{+.Music()}} for adding a tempo to a \code{Music} object.
}
