% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-construct-pedal.R
\name{Pedal}
\alias{Pedal}
\title{Create \code{Pedal} Object}
\usage{
Pedal(i, j, to = NULL)
}
\arguments{
\item{i, j}{A single positive integer. They indicate the start
and end position of the \code{Pedal} object in a musical line.}

\item{to}{Optional. A single character or a single positive integer,
which indicates the musical line where to add the \code{Pedal} object.}
}
\value{
A list of class \code{Pedal}.
}
\description{
Create a \code{Pedal} object to represent piano sustain pedal marks.
}
\examples{
# Create a `Pedal`
pedal <- Pedal(1, 3)
pedal

# Add it to a `Music`
music <- Music() + Meter(4, 4) + Line(c("C4", "D4", "E4")) + pedal
music

# Generate the music score
if (interactive()) {
  show(music)
}
}
\seealso{
\code{\link[=+.Music]{+.Music()}} for adding a \code{Pedal} to a \code{Music} object.
}
