% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{sim_glmmfields}
\alias{sim_glmmfields}
\title{Simulate a random field with a MVT distribution}
\usage{
sim_glmmfields(
  n_knots = 15,
  n_draws = 10,
  gp_theta = 0.5,
  gp_sigma = 0.2,
  mvt = TRUE,
  df = 1e+06,
  seed = NULL,
  n_data_points = 100,
  sd_obs = 0.1,
  covariance = c("squared-exponential", "exponential", "matern"),
  matern_kappa = 0.5,
  obs_error = c("normal", "gamma", "poisson", "nb2", "binomial", "lognormal"),
  B = c(0),
  phi = 0,
  X = rep(1, n_draws * n_data_points),
  g = data.frame(lon = runif(n_data_points, 0, 10), lat = runif(n_data_points, 0, 10))
)
}
\arguments{
\item{n_knots}{The number of knots}

\item{n_draws}{The number of draws (for example, the number of years)}

\item{gp_theta}{The Gaussian Process scale parameter}

\item{gp_sigma}{The Gaussian Process variance parameter}

\item{mvt}{Logical: MVT? (vs. MVN)}

\item{df}{The degrees of freedom parameter for the MVT distribution}

\item{seed}{The random seed value}

\item{n_data_points}{The number of data points per draw}

\item{sd_obs}{The observation process scale parameter}

\item{covariance}{The covariance function of the Gaussian process
("squared-exponential", "exponential", "matern")}

\item{matern_kappa}{The optional matern parameter. Can be 1.5 or 2.5. Values
of 0.5 equivalent to exponential model.}

\item{obs_error}{The observation error distribution}

\item{B}{A vector of parameters. The first element is the intercept}

\item{phi}{The auto regressive parameter on the mean of the random field knots}

\item{X}{The model matrix}

\item{g}{Grid of points}
}
\description{
Simulate a random field with a MVT distribution
}
\examples{
s <- sim_glmmfields(n_draws = 12, n_knots = 12, gp_theta = 1.5,
  gp_sigma = 0.2, sd_obs = 0.2)
names(s)
}
