% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barcharts.R
\name{ggbarcrosstabs}
\alias{ggbarcrosstabs}
\title{Crosstabs of Two Variables}
\usage{
ggbarcrosstabs(df, x, y, weights, fill = NULL, labeller = NULL)
}
\arguments{
\item{df}{data frame of survey}

\item{x}{variable to bar chart}

\item{y}{faceting variable}

\item{weights}{survey weights that sum to sample size}

\item{fill}{if true the fill of each bar will be a different color corresponding to the level of the factor}

\item{labeller}{argument to pass onto facet_grid}
}
\value{
ggplot object
}
\description{
In ggsurvey you specify both the plotting variables and weights in plain text with no quotes.
This function creates a crosstab of x by a second variable y.
}
\examples{
library(survey)
data(api)
ggbarcrosstabs(apistrat, stype, yr.rnd, pw)+ylab("Proportion")
ggbarcrosstabs(apistrat, stype, yr.rnd, pw, fill = TRUE)+ylab("Proportion")
data(nhanes)
ggbarcrosstabs(nhanes, race, agecat, WTMEC2YR)
}
