% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_envfit.R
\name{gg_envfit}
\alias{gg_envfit}
\title{Vegan envfit plot}
\usage{
gg_envfit(
  ord,
  env,
  groups = NA,
  scaling = 1,
  choices = c(1, 2),
  perm = 999,
  alpha = 0.05,
  angle = 20,
  len = 0.5,
  unit = "cm",
  arrow.col = "red",
  pt.size = 3,
  plot = TRUE
)
}
\arguments{
\item{ord}{An ordination object.}

\item{env}{A data frame of environmental parameters.}

\item{groups}{A vector of groups.}

\item{scaling}{Scaling value for plot.}

\item{choices}{Axes to plot.}

\item{perm}{Number of permutations.}

\item{alpha}{Maximum alpha value to be included in plot.}

\item{angle}{Angle of arrow tips.}

\item{len}{Arrow tip length.}

\item{unit}{Unit for length ("cm", "in")}

\item{arrow.col}{Arrow color.}

\item{pt.size}{Symbol size.}

\item{plot}{A logical for plotting; defaults to TRUE.}
}
\value{
Silently returns the plot and data frames used for the plotting if the fit of any variable is significant at alpha. Otherwise returns a message that no variable is significant.
}
\description{
Fits environmental parameters to an ordination plot of sites
and plots them as arrows.
}
\note{
In order for the arrow tips to be labeled with the names of the variables, they must be supplied as a matrix or data frame. If a single variable is supplied as a vector, the arrow tip will be labeled with "1". A way-around is to convert the vector to a data frame with the column named for the variable.
}
\examples{
data("varespec")
data("varechem")
vare.dist <- vegdist(varespec)
vare.mds <- monoMDS(vare.dist)
gg_envfit(ord=vare.mds, env=varechem)

data("dune")
data("dune.env")
dune.dist <- vegdist(dune)
dune.mds <- monoMDS(dune.dist)
# A1 supplied as a vector
gg_envfit(dune.mds, env=dune.env$A1, groups=dune.env$Management)
# A1 supplied as a data frame
A1 <- as.data.frame(dune.env$A1)
colnames(A1) <- "A1"
gg_envfit(dune.mds, env=A1, groups=dune.env$Management)

}
