% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggelement.R
\name{element_blinds}
\alias{element_blinds}
\title{this element is used to control the line color of panel.grid.major/minor.x
or panel.grid.major/minor.y}
\usage{
element_blinds(
  colour = c("white", "grey60"),
  axis,
  color = NULL,
  inherit.blank = FALSE
)
}
\arguments{
\item{colour}{the colour of rectangular, default is c('white', 'grey60').}

\item{axis}{character, require, option is \code{y} or \code{x}.}

\item{color, }{Color is an alias for colour}

\item{inherit.blank}{Should this element inherit the existence of an
\code{element_blank} among its parents? If \code{TRUE} the existence of
a blank element among its parents will cause this element to be blank as
well. If \code{FALSE} any blank parent element will be ignored when
calculating final element state.}
}
\description{
this element is used to control the line color of panel.grid.major/minor.x
or panel.grid.major/minor.y
}
\examples{
library(ggplot2)
df <- data.frame(
         x = rep(c(2, 5, 7, 9, 12), 2),
         y = rep(c(1, 2), each = 5),
         z = factor(rep(1:5, each = 2)),
         w = rep(diff(c(0, 4, 6, 8, 10, 14)), 2)
       )
ggplot(df, aes(x, y)) + geom_tile(aes(fill = z), colour = 'grey50') + 
theme(panel.grid.major.y = element_blinds(color= c('white', 'grey'), axis='y'))
}
