% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pyramid_chart.R
\name{pyramid_chart}
\alias{pyramid_chart}
\title{Pyramid Chart}
\usage{
pyramid_chart(
  data,
  x,
  y,
  group,
  bar_colors = c("#1F77B4", "#FF7F0E"),
  sort = "no",
  xlab = NULL,
  title = NULL
)
}
\arguments{
\item{data}{Dataset to use for the pyramid chart}

\item{x}{\code{character} or \code{factor} column of \code{data}}

\item{y}{\code{numeric} column of \code{data}}

\item{group}{\code{character} or \code{factor} column of \code{data}}

\item{bar_colors}{\code{character} vector of length 2 containing colors}

\item{sort}{\code{character}. Should the bars be sorted? By default \code{"no"}.}

\item{xlab}{\code{character}. X axis label}

\item{title}{\code{character}. Plot title. By default no title is displayed.}
}
\value{
An object of class \code{ggplot}
}
\description{
Easily create a pyramid chart
}
\examples{
data(popch)

pyramid_chart(popch, age, pop, sex)

## Change bar colors
pyramid_chart(popch, age, pop, sex, bar_colors = c("darkgreen", "darkorange"))

## Change x axis label and add title
pyramid_chart(popch, age, pop, sex, xlab = "Population", title = "Switzerland 2020")

}
\author{
Thomas Neitmann
}
