% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relations.R
\name{get_unrelated_instances}
\alias{get_unrelated_instances}
\alias{get_unrelated_instances.geodimension}
\title{Get unrelated instances}
\usage{
get_unrelated_instances(gd, lower_level_name, upper_level_name)

\method{get_unrelated_instances}{geodimension}(gd, lower_level_name = NULL, upper_level_name = NULL)
}
\arguments{
\item{gd}{A \code{geodimension} object.}

\item{lower_level_name}{A string, name of the lower level.}

\item{upper_level_name}{A string, name of the upper lever.}
}
\value{
A \code{tibble}, unrelated lower level instances.
}
\description{
Given two previously related levels of a dimension, it obtains the instances
of the lower level that have not been related to the upper level.
}
\examples{

layer_us_place <- gd_us |>
  get_level_layer("place")

layer_us_county <-
  dplyr::inner_join(
    get_level_data_geo(gd_us, "county"),
    get_level_layer(gd_us, "county"),
    by = c("geoid", "statefp", "name", "type")
  ) |>
  sf::st_as_sf()

place <-
  geolevel(name = "place",
           layer = layer_us_place,
           attributes = c("statefp", "county_geoid", "name", "type"),
           key = "geoid")

county <-
  geolevel(
    name = "county",
    layer = layer_us_county,
    attributes = c("statefp", "name", "type"),
    key = "geoid"
  ) |>
  add_geometry(coordinates_to_geometry(layer_us_county,
                                       lon_lat = c("intptlon", "intptlat")))

gd <-
  geodimension(name = "gd_us",
               level = place) |>
  add_level(level = county)

gd <- gd |>
  relate_levels(
    lower_level_name = "place",
    upper_level_name = "county",
    by_geography = TRUE
  )

ui <- gd |>
  get_unrelated_instances(
    lower_level_name = "place",
    upper_level_name = "county"
  )

}
\seealso{
\code{\link{geodimension}}, \code{\link{geolevel}}

Other relationship between geolevels: 
\code{\link{complete_relation_by_geography}()},
\code{\link{relate_levels}()},
\code{\link{select_levels}()}
}
\concept{relationship between geolevels}
