% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geolevel.R
\name{add_geometry}
\alias{add_geometry}
\alias{add_geometry.geolevel}
\title{Add geometry to a level}
\usage{
add_geometry(gl, layer, layer_key, level_key)

\method{add_geometry}{geolevel}(gl, layer = NULL, layer_key = NULL, level_key = NULL)
}
\arguments{
\item{gl}{A \code{geolevel} object.}

\item{layer}{A \code{sf} object.}

\item{layer_key}{A vector of string.}

\item{level_key}{A vector of string.}
}
\value{
A \code{geolevel}.
}
\description{
A level can have several geometries (\emph{point} or \emph{polygon}). This function adds
the geometry of the layer to the level.
}
\details{
The association of the geometry to the existing instances is done through join
using the level and layer keys.

If none is indicated, by default the key defined in the level is considered.
}
\examples{

layer_us_state <-
  dplyr::inner_join(
    get_level_data_geo(gd_us, "state"),
    get_level_layer(gd_us, "state"),
    by = c("statefp", "division", "region", "stusps", "name")
  ) |>
  sf::st_as_sf()

us_state_point <-
  coordinates_to_geometry(layer_us_state,
                          lon_lat = c("intptlon", "intptlat"))

state <-
  geolevel(name = "state",
           layer = layer_us_state,
           key = "statefp",
           snake_case = TRUE) |>
  add_geometry(layer = us_state_point)

}
\seealso{
\code{\link{geodimension}}, \code{\link{relate_levels}}

Other geolevel definition functions: 
\code{\link{check_key}()},
\code{\link{complete_point_geometry}()},
\code{\link{coordinates_to_geometry}()},
\code{\link{geolevel}()},
\code{\link{get_empty_geometry_instances}()},
\code{\link{get_geometry}()}
}
\concept{geolevel definition functions}
