% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbp3d_cpp_rd.r
\name{gbp3d_solver_dpp_filt}
\alias{gbp3d_solver_dpp_filt}
\title{gbp3d_solver_dpp_filt}
\usage{
gbp3d_solver_dpp_filt(ldh, m)
}
\arguments{
\item{ldh}{it scale <matrix>
- l, d, h it scale along x, y, z <numeric>}

\item{m}{bn scale <matrix>
 - l, d, h bn scale along x, y, z <numeric>
 - l, d, h in row and each col is a single bn

 should make sure bn list are sorted via volume
  so that the first col is the most prefered smallest bn, and also
  the last col is the least prefered largest and often dominant bn

 should make sure no X in front of Y if bnX dominant bnY,
  bnX dominant bnY if all(X(l, d, h) > Y(l, d, h)) and should always prefer Y.

 should make sure bn such that l >= d >= h or vice versa.}
}
\value{
gbp3q
 a gbp3q instantiate with p profit, it item (x, y, z, l, d, h) position scale matrix, bn bin (l, d, h) scale matrix,
  k it selection, o objective, f bn selection, and ok an indicator of all fit or not.
}
\description{
solve gbp3d w.r.t select most preferable often smallest bin from bn list
}
\details{
gbp3d_solver_dpp_filt is built on top of gbp3d_solver_dpp
  aims to select the most preferable bn from a list of bn that can fit all or most it

 gbp3d_solver_dpp()'s objective is fit all or most it into a single given bn (l, d, h)

 gbp3d_solver_dpp_filt()'s objective is select the most preferable given a list of bn
  where bn list is specified in 3xN matrix that the earlier column the more preferable

 gbp3d_solver_dpp_filt() use an approx binary search and determine f w.r.t bn.n_cols
  where f = 1 indicate the bn being selected and only one of 1 in result returned.

 ok = true if any bin can fit all it and algorithm will select smallest bn can fit all
  otherwise ok = false and algorithm will select a bn can maximize volume of fitted it

 often recommend to make the last and least preferable bn dominate all other bn in list
  when design bn list, bnX dominant bnY if all(X(l, d, h) > Y(l, d, h)).
}
\seealso{
Other gbp3q: \code{\link{gbp3q_checkr}},
  \code{\link{gbp3q}}
}

