# WARNING - Generated by {fusen} from dev/flat_internal.Rmd: do not edit by hand

test_that("norm2", {
    expect_equal(norm2(numeric(10)), 0)
    vec <- rnorm(100)
    expect_equal(norm2(vec), norm(as.matrix(vec), type = "F"))
})

test_that("prepare_data", {
    
    n_point = 100
    n_obs1 = 50
    n_obs2 = 75
    simu_data <- simul_data(
        n_point, n_obs1, n_obs2, c_val = 10, 
        delta_shape = "constant", distrib = "normal"
    )
    
    data2plot <- bind_rows(
        prepare_data(simu_data$mat_sample1, sample_id = 1),
        prepare_data(simu_data$mat_sample2, sample_id = 2)
    )
    
    checkmate::expect_tibble(
        data2plot, ncols = 4, nrows = n_point*n_obs1 + n_point*n_obs2,
        any.missing = FALSE
    )
    expect_equal(
        colnames(data2plot), 
        c("sample", "point", "trajectory", "value")
    )
})

test_that("permut_stats", {
    MatX <- matrix(rnorm(100), nrow = 25, ncol = 4)
    MatY <- matrix(rnorm(125), nrow = 25, ncol = 5) + 10
    
    n_perm <- 10
    stat <- "mo"
    res <- permut_stats(
        MatX, MatY, n_perm, stat, verbose = FALSE, return_perm = FALSE)
    checkmate::expect_list(res, len = length(stat))
    expect_equal(names(res), stat)
    for(stat_name in stat) {
        cat("# stat:", stat_name, "\n")
        n_row <- switch (stat_name, "hkr" = 2, 1)
        checkmate::expect_matrix(
            res[[stat_name]], mode = "numeric", any.missing = FALSE, 
            nrows = n_row, ncols = n_perm
        )
    }
    
    n_perm <- 10
    stat <- "mo"
    res <- permut_stats(
        MatX, MatY, n_perm, stat, verbose = TRUE, return_perm = FALSE)
    checkmate::expect_list(res, len = length(stat))
    expect_equal(names(res), stat)
    for(stat_name in stat) {
        cat("# stat:", stat_name, "\n")
        n_row <- switch (stat_name, "hkr" = 2, 1)
        checkmate::expect_matrix(
            res[[stat_name]], mode = "numeric", any.missing = FALSE, 
            nrows = n_row, ncols = n_perm
        )
    }
    
    n_perm <- 10
    stat <- "mo"
    res <- permut_stats(MatX, MatY, n_perm, stat, return_perm = TRUE)
    checkmate::expect_list(res, len = length(stat) + 1)
    expect_equal(names(res), c(stat, "perm_matrix"))
    for(stat_name in stat) {
        cat("# stat:", stat_name, "\n")
        n_row <- switch (stat_name, "hkr" = 2, 1)
        checkmate::expect_matrix(
            res[[stat_name]], mode = "numeric", any.missing = FALSE, 
            nrows = n_row, ncols = n_perm
        )
    }
    checkmate::expect_matrix(
        res[["perm_matrix"]], mode = "integerish", any.missing = FALSE, 
        nrows = ncol(MatX) + ncol(MatY), ncols = n_perm
    )
    # verify each values on permutations
    MatW <- cbind(MatX, MatY)
    M <- ncol(MatX)
    N <- ncol(MatY)
    for(stat_name in stat) {
        cat("# stat:", stat_name, "\n")
        cat("rep: ")
        for(rep in 1:n_perm) {
            cat(rep, " ")
            tmp_perm <- res[["perm_matrix"]][,rep]
            MatXsim <- MatW[,tmp_perm[1:M]]
            MatYsim <- MatW[,tmp_perm[(M+1):(M+N)]]
            tmp_res <- comp_stat(MatXsim, MatYsim, stat_name)
            expect_equal(tmp_res[[stat_name]], res[[stat_name]][rep])
        }
    }
    
    n_perm <- 100
    stat <- c("mo", "med", "wmw", "hkr", "cff")
    res <- permut_stats(MatX, MatY, n_perm, stat, return_perm = TRUE)
    checkmate::expect_list(res, len = length(stat) + 1)
    expect_equal(names(res), c(stat, "perm_matrix"))
    for(stat_name in stat) {
        cat("# stat:", stat_name, "\n")
        n_row <- switch (stat_name, "hkr" = 2, 1)
        checkmate::expect_matrix(
            res[[stat_name]], mode = "numeric", any.missing = FALSE, 
            nrows = n_row, ncols = n_perm
        )
    }
    checkmate::expect_matrix(
        res[["perm_matrix"]], mode = "integerish", any.missing = FALSE, 
        nrows = ncol(MatX) + ncol(MatY), ncols = n_perm
    )
    # verify each values on permutations
    MatW <- cbind(MatX, MatY)
    M <- ncol(MatX)
    N <- ncol(MatY)
    for(stat_name in stat) {
        cat("# stat:", stat_name, "\n")
        cat("perm: ")
        for(rep in 1:n_perm) {
            if(rep %% (n_perm %/% 10) == 1) cat("...")
            if(rep %% (n_perm %/% 10) == 0) cat(rep)
            tmp_perm <- res[["perm_matrix"]][,rep]
            MatXsim <- MatW[,tmp_perm[1:M]]
            MatYsim <- MatW[,tmp_perm[(M+1):(M+N)]]
            tmp_res <- comp_stat(MatXsim, MatYsim, stat_name)
            # print(unname(as.vector(tmp_res[[stat_name]])))
            # print(res[[stat_name]][,rep])
            expect_equal(
                unname(as.vector(tmp_res[[stat_name]])), 
                unname(as.vector(res[[stat_name]][,rep]))
            )
        }
        cat("\n")
    }
})

test_that("pval_stat", {
    MatX <- matrix(rnorm(100), nrow = 25, ncol = 4)
    MatY <- matrix(rnorm(125), nrow = 25, ncol = 5) + 10
    
    cat("one stat MO\n")
    n_perm <- 10
    stat <- "mo"
    # test preparation
    # original values on non-permuted samples
    original_value <- comp_stat(MatX, MatY, stat)
    # global data matrix
    MatW <- cbind(MatX, MatY)
    M <- ncol(MatX)
    N <- ncol(MatY)
    # compute permutation-based stat values
    perm_values <- permut_stats(MatX, MatY, n_perm, stat)
    # compute pval and check
    for(stat_name in stat) {
        cat("# stat:", stat_name, "\n")
        res <- pval_stat(original_value[[stat_name]], perm_values[[stat_name]])
        tmp_res <- sum(
                perm_values[[stat_name]] > original_value[[stat_name]])
            expect_equal((tmp_res+2)/(n_perm+1), res)
    }
    
    cat("one stat HKR\n")
    n_perm <- 10
    stat <- "hkr"
    # test preparation
    # original values on non-permuted samples
    original_value <- comp_stat(MatX, MatY, stat)
    # global data matrix
    MatW <- cbind(MatX, MatY)
    M <- ncol(MatX)
    N <- ncol(MatY)
    # compute permutation-based stat values
    perm_values <- permut_stats(MatX, MatY, n_perm, stat)
    # compute pval and check
    for(stat_name in stat) {
        cat("# stat:", stat_name, "\n")
        res <- pval_stat(original_value[[stat_name]], perm_values[[stat_name]])
        for(ind in 1:2) {
            tmp_res <- sum(
                perm_values[[stat_name]][ind,] > 
                    original_value[[stat_name]][ind])
            expect_equal((tmp_res+2)/(n_perm+1), unname(res[ind]))
        }
    }
    
    cat("all stat\n")
    n_perm <- 1000
    stat <- c("mo", "med", "wmw", "hkr", "cff")
    # test preparation
    # original values on non-permuted samples
    original_value <- comp_stat(MatX, MatY, stat)
    # global data matrix
    MatW <- cbind(MatX, MatY)
    M <- ncol(MatX)
    N <- ncol(MatY)
    # compute permutation-based stat values
    perm_values <- permut_stats(MatX, MatY, n_perm, stat)
    # compute pval and check
    for(stat_name in stat) {
        cat("# stat:", stat_name, "\n")
        res <- pval_stat(original_value[[stat_name]], perm_values[[stat_name]])
        if(stat_name == "hkr") {
            for(ind in 1:2) {
                tmp_res <- sum(
                    perm_values[[stat_name]][ind,] > 
                        original_value[[stat_name]][ind])
                expect_equal((tmp_res+2)/(n_perm+1), unname(res[ind]))
            }
        } else {
            tmp_res <- sum(
                perm_values[[stat_name]] > original_value[[stat_name]])
            expect_equal((tmp_res+2)/(n_perm+1), res)
        }
    }
})
