% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3objectsdoc.R
\name{tclustreg.object}
\alias{tclustreg.object}
\title{Objects returned by the function \code{\link{tclustreg}}}
\value{
The functions \code{print()} and \code{summary()} are used to obtain and print a
 summary of the results. An object of class \code{tclustreg} is a list containing at least the following components:
 \item{call}{the matched call}
}
\description{
An object of class \code{\link{tclustreg.object}} holds information about
 the result of a call to \code{\link{tclustreg}}.
}
\examples{

 \dontrun{

 ## The X data have been introduced by Gordaliza, Garcia-Escudero & Mayo-Iscar (2013).
 ## The dataset presents two parallel components without contamination.

 data(X)
 y1 = X[, ncol(X)]
 X1 = X[,-ncol(X), drop=FALSE]

 out <- tclustreg(y1, X1, k=2, alphaLik=0.05, alphaX=0.01, restrfactor=5, trace=TRUE)
 class(out)
 str(out)
 }
}
\seealso{
\code{\link{tclustreg}}
}
\keyword{multivariate}
\keyword{robust}
