% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3objectsdoc.R
\name{tclustic.object}
\alias{tclustic.object}
\title{Objects returned by the function \code{\link{tclustIC}}}
\value{
The functions \code{print()} and \code{summary()} are used to obtain and print a
 summary of the results. An object of class \code{tclustic} is a list containing at least the following components:
 \item{call}{the matched call}
 \item{kk}{a vector containing the values of \code{k} (number of components) which have been considered.
     This vector is identical to the optional argument \code{kk} (default is \code{kk=1:5}.}
 \item{cc}{a vector containing the values of \code{c} (values of the restriction factor) which
     have been considered. This vector is identical to the optional argument \code{cc} (defalt is \code{cc=c(1, 2, 4, 8, 16, 32, 64, 128)}.}
 \item{alpha}{trimming level}
 \item{whichIC}{Information criteria used}
 \item{CLACLA}{a matrix of size \code{length(kk)-times-length(cc)} containinig the value of
     the penalized classification likelihood. This output is present only if \code{whichIC="CLACLA"} or  \code{whichIC="ALL"}.}
 \item{IDXCLA}{a matrix of lists of size \code{length(kk)-times-length(cc)} containinig the assignment of each unit
     using the classification model. This output is present only if \code{whichIC="CLACLA"} or  \code{whichIC="ALL"}.}
 \item{MIXMIX}{a matrix of size \code{length(kk)-times-length(cc)} containinig the value of
     the penalized mixtrue likelihood. This output is present only if \code{whichIC="MIXMIX"} or  \code{whichIC="ALL"}.}
 \item{IDXMIX}{a matrix of lists of size \code{length(kk)-times-length(cc)} containinig the assignment of each unit
     using the classification model. This output is present only if \code{whichIC="MIXMIX"} or  \code{whichIC="ALL"}.}
 \item{MIXCLA}{a matrix of size \code{length(kk)-times-length(cc)} containinig the value of
     the ICL criterion. This output is present only if \code{whichIC="MIXCLA"} or  \code{whichIC="ALL"}.}
}
\description{
An object of class \code{\link{tclustic.object}} holds information about
 the result of a call to \code{\link{tclustIC}}.
}
\examples{

 \dontrun{
 data(hbk, package="robustbase")
 (out <- tclustIC(hbk[, 1:3]))
 class(out)
 summary(out)
 }
}
\keyword{multivariate}
\keyword{robust}
