% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluspect.R
\name{write.leafopt}
\alias{write.leafopt}
\title{write.leafopt}
\usage{
write.leafopt(leafopt, path, digits = 5)
}
\arguments{
\item{leafopt}{List. Spectral object generated with \link{fluspect}}

\item{path}{String. Output path. If the directory does not exist, a new one will be created.}

\item{digits}{Integer. (Optional) Number of digits (by default 5)}
}
\description{
\code{write.leafopt} writes the leafopt object as text files
}
\details{
It always writes the text files in UNIX format, under the specified output path. It will override if files already exists.
The output filenames are:
\itemize{
\item leafoptrefl.txt
\item leafopttran.txt
\item leafoptkChlrel.txt
\item leafoptMbI.txt
\item leafoptMbII.txt
\item leafoptMfI.txt
\item leafoptMbII.txt
}
}
\examples{
leafbio <- data.frame(Cab = 70, Cca = 30, Cw = 0.013, Cdm = 0.024, Cs = 0.0, N = 4.09, fqe = 0.02)
leafopt <- fluspect(leafbio)
write.leafopt(leafopt, path = file.path(tempdir(), 'output'))

}
\author{
Alberto Hornero
}
