% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy_inference.R
\name{compute_ci}
\alias{compute_ci}
\title{Compute confidence intervals for regression coefficients}
\usage{
compute_ci(beta_hat, se_beta, df, alpha = 0.05)
}
\arguments{
\item{beta_hat}{Numeric vector. Estimated regression coefficients.}

\item{se_beta}{Numeric vector. Standard errors of coefficients.}

\item{df}{Integer. Degrees of freedom.}

\item{alpha}{Numeric. Significance level (default: 0.05).}
}
\value{
A list containing lower and upper bounds of confidence intervals.
}
\description{
Compute confidence intervals for regression coefficients
}
\examples{
beta_hat <- c(0.5, 1.2)  # Example regression coefficients
se_beta <- c(0.1, 0.2)  # Example standard errors
df <- 30  # Example degrees of freedom
ci <- compute_ci(beta_hat, se_beta, df)
print(ci)
}
