% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flash_greedy_init_fns.R
\name{flash_greedy_init_default}
\alias{flash_greedy_init_default}
\title{Initialize a flash factor}
\usage{
flash_greedy_init_default(
  flash,
  sign_constraints = NULL,
  tol = NULL,
  maxiter = 100,
  seed = 666
)
}
\arguments{
\item{flash}{A \code{flash_fit} object.}

\item{sign_constraints}{This parameter can be used to constrain the sign of
the initial factor and loadings. It should be a vector of length two with
entries equal to -1, 0, or 1. The first entry constrains the sign of the
loadings \eqn{\ell_{\cdot k}}, with -1 yielding nonpositive loadings, +1
yielding nonnegative loadings, and 0 indicating that loadings should not be
constrained. The second entry of \code{sign_constraints} similarly
constrains the sign of factor values \eqn{f_{\cdot k}}. If
\code{sign_constraints = NULL}, then no constraints will be applied.}

\item{tol}{Convergence tolerance parameter. When the maximum (absolute)
change over all values \eqn{\ell_{ik}} and \eqn{f_{jk}} is less than or
equal to \code{tol}, initialization terminates. At each iteration, the
factor and loadings are \eqn{L^2}-normalized. The default tolerance
parameter is \eqn{\min(1 / n, 1 / p)}, where \eqn{n} is
the number of rows in the data matrix and \eqn{p} is the number of columns.}

\item{maxiter}{Maximum number of power iterations.}

\item{seed}{Since initialization is random, a default seed is set for
reproducibility.}
}
\value{
A list of length two consisting of, respectively, the vector of
  initial values for loadings \eqn{\ell_{\cdot k}} and the vector of initial
  factor values \eqn{f_{\cdot k}}.
}
\description{
The default method for initializing the loadings \eqn{\ell_{\cdot k}} and
  factor values \eqn{f_{\cdot k}} of a new ("greedy") flash factor. It is
  essentially an implementation of the power method, but unlike many existing
  implementations, it can handle missing data and sign constraints. For details,
  see Chapter 2.2.3 in the reference below.
}
\references{
Jason Willwerscheid (2021), \emph{Empirical Bayes Matrix Factorization:
  Methods and Applications}. Ph.D. thesis, University of Chicago.
}
\seealso{
\code{\link{flash_greedy}},
  \code{\link{flash_greedy_init_softImpute}},
  \code{\link{flash_greedy_init_irlba}}
}
