% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookup.R
\name{as_fips}
\alias{as_fips}
\title{Convert a state name, abbreviation, or county name to FIPS codes}
\usage{
as_fips(state, county = NULL)
}
\arguments{
\item{state}{State names, state abbreviations, or
one of the following: "all", "conus", "territories"}

\item{county}{County names or "all"}
}
\value{
a \code{character} vector
}
\description{
Convert a state name, abbreviation, or county name to FIPS codes
}
\examples{
fipio::as_fips(state = "California")
fipio::as_fips(state = "NC")
fipio::as_fips(state = "Rhode Island", county = "Washington")
fipio::as_fips(c("CA", "North Carolina"), c("Stanislaus", "NEW HANOVER"))
fipio::as_fips("CONUS")
fipio::as_fips(state = "NC", county = "all")

}
