% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fig_functions.R
\name{fig_get}
\alias{fig_get}
\alias{fig_get_many}
\alias{fig_get_all}
\title{Retrieve Stored Values}
\usage{
fig_get(key)

fig_get_many(...)

fig_get_all()
}
\arguments{
\item{key}{A key to retrieve a value for.}

\item{...}{Keys to retrieve values for.}
}
\value{
A value associated with provided \code{key}.

An unnamed list of values associated with keys provided in \code{...}.

An unnamed list of all stored values.
}
\description{
These functions allow retrieving values stored in the global fig
instance.
}
\details{
These functions return values based on a following priority
(highest to lowest). If value is not found, then it looks up next level
in the precedence.
\enumerate{
\item System environment variable (case sensitive)
\item Value manually set
}

For system environment lookup dots are replaced by underscores, e.g.
\code{fig_get("foo.bar")} will look up \strong{foo_bar}.
}
\examples{
fig_store("foo", 1)
fig_get("foo")

fig_store("bar", list(baz = 2))
fig_get("bar.baz")

fig_configure(split_on = "")
fig_get("bar.baz") # == NULL
fig_store_many(foo = 1, bar = 2, baz = 3)
fig_get_many("foo", "bar")
fig_store_many(foo = 1, bar = 2, baz = 3)
fig_get_all()
}
