% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data.R
\name{download_data}
\alias{download_data}
\title{Access data stored online.}
\usage{
download_data(x, destfile = NULL)
}
\arguments{
\item{x}{A string giving the name of the dataset to download. The name
of any dataset listed \href{https://github.com/forestgeo/fgeo.data/tree/master/data}{here} (without the
extension).}

\item{destfile}{a character string (or vector, see \code{url}) with
    the name where the downloaded file is saved.  Tilde-expansion is
    performed.}
}
\value{
A dataset.
}
\description{
Access data stored online.
}
\examples{
# Not running CRAN checks (may take longer than the allowed run time limit)
\donttest{
# Defaults to read data
# The first call is memoised
system.time(download_data("unique_id"))
# Subsequent calls use the memoised data, so takes no time
system.time(download_data("unique_id"))

download_data("unique_id")

# Can download data to a destination file given by `destfile`
tmp <- tempfile()
download_data("unique_id", destfile = tmp)
load(tmp)
unique_id

available_data <- "https://github.com/forestgeo/fgeo.data/tree/master/data"
if (interactive()) browseURL(available_data)
}
}
\seealso{
\code{\link[utils:download.file]{utils::download.file()}}

Other datasets: \code{\link{datasets}},
  \code{\link{example_path}}
}
\concept{datasets}
