% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodNF.R
\name{fence.NF}
\alias{fence.NF}
\title{Fence model selection (Nonparametric Model)}
\usage{
fence.NF(full, data, spline, ps = 1:3, qs = NA, B = 100, grid = 101,
  bandwidth = NA, lambda)
}
\arguments{
\item{full}{formula of full model}

\item{data}{data}

\item{spline}{variable needed for spline terms}

\item{ps}{order of power}

\item{qs}{number of knots}

\item{B}{number of bootstrap sample, parametric for lmer}

\item{grid}{grid for c}

\item{bandwidth}{bandwidth for kernel smooth function}

\item{lambda}{A grid of lambda values}
}
\value{
\item{models}{list all model candidates with p polynomial degrees and q knots in the model space}
\item{Qd_matrix}{list a matrix of QM - QM.tilde for all model candidates. Each row is for each bootrap sample}
\item{bandwidth}{list the value of bandwidth}
\item{model_mat}{list a matrix of selected models at each c values in grid (in columns). Each row is for each bootstrap sample}
\item{freq_mat}{list a matrix of coverage probabilities (frequency/smooth_frequency) of each selected models for a given c value (index)}
\item{c}{list the adaptive choice of c value from which the parsimonious model is selected}
\item{lambda}{penalty (or smoothing) parameter estimate given selected p and q}
\item{sel_model}{list the selected (parsimonious) model given the adaptive c value}
\item{beta.est.u}{A list of coefficient estimates given a lambda value}
\item{f.x.hat}{A vector of fitted values obtained from a given lambda value and beta.est.u}
 @note The current Fence method in Nonparametric model focuses on one spline variable. 
 This method can be extended to a general case with more than one spline variables, and includes non-spline variables.
}
\description{
Fence model selection (Noparametric Model)
}
\examples{
\dontrun{
require(fence)
n = 100
set.seed(1234)
x=runif(n,0,3)
y = 1-x+x^2- 2*(x-1)^2*(x>1) + 2*(x-2)^2*(x>2) + rnorm(n,sd=.2)
lambda=exp((c(1:60)-30)/3)
data=data.frame(cbind(x,y))   
test_NF = fence.NF(full=y~x, data=data, spline='x', ps=c(1:3), qs=c(2,5), B=1000, lambda=lambda)
plot(test_NF)
summary <- summary(test_NF) 
model_sel <- summary[[1]]
model_sel
lambda_sel <- summary[[2]]
lambda_sel
}
}
\references{
\itemize{
 \item{Jiang J., Rao J.S., Gu Z., Nguyen T. (2008),  Fence Methods for Mixed Model Selection. The Annals of Statistics, 36(4): 1669-1692}
 \item{Jiang J., Nguyen T., Rao J.S. (2009), A Simplified Adaptive Fence Procedure. Statistics and Probability Letters, 79, 625-629}
 \item{Jiang J., Nguyen T., Rao J.S. (2010), Fence Method for Nonparametric Small Area Estimation. Survey Methodology, 36, 1, 3-11}
}
}
\author{
Jiming Jiang Jianyang Zhao J. Sunil Rao Bao-Qui Tran Thuan Nguyen
}
