% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_convertors.R
\name{nbinom2norm}
\alias{nbinom2norm}
\title{Convert negative binomial to normal}
\usage{
nbinom2norm(x, mu = 0, sd = 1, size = NULL, prob = NULL)
}
\arguments{
\item{x}{the negative binomially distributed vector}

\item{mu}{the mean of the normal distribution to return}

\item{sd}{the SD of the normal distribution to return}

\item{size}{number of trials (set to max value of x if not specified)}

\item{prob}{the probability of success on each trial (set to mean probability if not specified)}
}
\value{
a vector with a gaussian distribution
}
\description{
Convert a negative binomial distribution to a normal (gaussian) distribution with specified mu and sd
}
\examples{

x <- rnbinom(10000, 20, 0.75)
y <- nbinom2norm(x, 0, 1, 20, 0.75)
g <- ggplot2::ggplot() + ggplot2::geom_point(ggplot2::aes(x, y))
ggExtra::ggMarginal(g, type = "histogram")

}
