% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric.cluster.median.R
\name{metric.cluster.median}
\alias{metric.cluster.median}
\title{Median Local Clustering Coefficient}
\usage{
metric.cluster.median(g)
}
\arguments{
\item{g}{The input network.}
}
\value{
A real constant.
}
\description{
Calculate the median local clustering coefficient of a graph.
}
\details{
The local clustering coefficient of a node is the ratio of the triangles connected to the node and the triples centered on the \code{node.metric.cluster.median()} calculates the (estimated) median clustering coefficient for all nodes in graph \emph{g} with a justified error.
}
\examples{
\dontrun{
x <-  net.erdos.renyi.gnp(1000, 0.1)
metric.cluster.median(x)}
}
\references{
Wasserman, Stanley, and Katherine Faust. Social network analysis: Methods and applications. Vol. 8. Cambridge university press, 1994.
}
\author{
Xu Dong, Nazrul Shaikh.
}
