% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventProb.R
\name{eventProb}
\alias{eventProb}
\title{Calculate event probabilities}
\usage{
eventProb(rateC, hrA, hrB, hrAB, mincens, maxcens)
}
\arguments{
\item{rateC}{group C one year event rate}

\item{hrA}{group A to group C hazard ratio}

\item{hrB}{group B to group C hazard ratio}

\item{hrAB}{group AB to group C hazard ratio}

\item{mincens}{minimum censoring time}

\item{maxcens}{maximum censoring time}
}
\value{
\item{hazC }{group C's exponential hazard rate}

\item{probC }{event probability of the C group}

\item{probA }{event probability of the A group}

\item{probB }{event probability of the B group}

\item{probAB }{event probability of the AB group}

\item{avgprob }{average event probability across all factorial groups}

\item{probA_C}{average event probablity of the A and C groups}

\item{probAB_C}{average event probablity of the AB and C groups}
}
\description{
Calculates the event probabilities for each of the four factorial groups
C, A, B, AB.  The time unit is in years, but of course, any time
unit could be used.  Average event probabilities across various
combinations of the groups are also calculated.
The event times are assumed to be exponentially distributed.  The
censoring times are assumed to be uniformly distributed and indepedent of
the event times.
}
\examples{
# Corresponds to scenario 5 of Table 2 from Leifer, Troendle, et al. (2019).
rateC <- 0.0445
hrA <- 0.80
hrB <- 0.80
hrAB <- 0.72
mincens <- 4.0
maxcens <- 8.4
eventProb(rateC, hrA, hrB, hrAB, mincens, maxcens)
# hazC
# [1] 0.04552052

# probC
# [1] 0.2446365

# probA
# [1] 0.201254

# probB
# [1] 0.201254

# probAB
# [1] 0.1831806

# avgprob
# [1] 0.2075813

# probAB_C
# [1] 0.2139086
}
