% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num2str.R
\name{fcvt}
\alias{fcvt}
\title{Number to String Conversion (Floating Point / Fractional Number)}
\usage{
fcvt(x, nsmall = 15, plus = FALSE, denom = -1)
}
\arguments{
\item{x}{numeric: numbers to convert}

\item{nsmall}{integer: number of significant digits for the mantissa/significand (default: \code{16})}

\item{plus}{logical: for positive numbers a plus sign should be used (default: \code{FALSE})}

\item{denom}{integer: denominator for a fractional number}
}
\value{
A character.
}
\description{
Converts a number to a string containing either a floating point or a fractional number.
Note that a repeating or recurring decimal, which is a number whose decimal representation becomes periodic,
can also be expressed as a rational number. For example, \eqn{\frac{1}{3}=0.333333333...=0.\overline{3}}.
It is the workhorse used in \code{num2str}.
\itemize{
\item If \code{denom} is negative then always decimal point numbers are used (default).
\item If \code{denom} is zero then a mix of decimal point and fractional numbers are used (whatever is shorter).
\item If \code{denom} is one then fractional numbers are used except for integers.
\item If \code{denom} is larger than one, then the denominator is set to \code{denom} if possible.
}
}
\examples{
x1 <- c(NA, NaN, -Inf, Inf, 0, pi*10^(-20:20))
fcvt(x1)
x2 <- c(-0.36, 3.6, -30.6, 0.36)
fcvt(x2)
x3 <- c((0:16)/8, 1/3)
fcvt(x3)           # as floating point number, equals denom=-1
fcvt(x3, denom=0)  # as floating point or fractional number
fcvt(x3, denom=1)  # as fractional number except for integers
fcvt(x3, denom=8)  # as fractional number with denominator denom if possible
}
