% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/persistence.R
\name{persistence}
\alias{persistence}
\title{Calculate the persistence of a state variable over a defined
time interval}
\usage{
persistence(
  type,
  metric_tf,
  b,
  b_tf = NULL,
  vd_i,
  td_i,
  d_data = NULL,
  vb_i = NULL,
  tb_i = NULL,
  b_data = NULL,
  comm_d = NULL,
  comm_b = NULL,
  comm_t = NULL,
  method = "bray",
  binary = "FALSE",
  low_lim = NULL,
  high_lim = NULL,
  na_rm = TRUE
)
}
\arguments{
\item{type}{a string defining the type of stability (\code{"functional"} or \code{"compositional"}) to be calculated.}

\item{metric_tf}{a numerical vector, specifying the beginning and end of the
time period over which the stability metric should be measured.}

\item{b}{a string stating whether the baseline is defined by a separate
baseline that is specified by the user (\code{b = "input"}) or by a
period of the disturbed system (\code{b = "d"}) prior to the disturbance.
This period is specified by \code{b_tf}.}

\item{b_tf}{a numerical vector, specifying the beginning and end of the
pre-disturbance time period for the disturbed time-series that defines
the baseline. Obligatory if (\code{b = "d"}), see 'Details'.}

\item{vd_i}{a numeric vector containing the state variable in the
disturbed system or a string specifying the name of the column
containing said variable in the dataframe provided in \code{d_data}.}

\item{td_i}{a numeric vector containing the time or a string specifying the
name of the column containing the time in the dataframe provided
in \code{d_data}.}

\item{d_data}{an optional data frame containing the time series of the
state variable values in a disturbed system.}

\item{vb_i}{an optional numeric vector containing the state variable in
the baseline, or a string for the name of the column in \code{b_data}
containing said variable in the dataframe with baseline values.}

\item{tb_i}{an optional numeric vector containing the time period over which
the baseline was measured, or a string for the name of the column in
\code{b_data} containing said the time variable in the dataframe
with baseline values.}

\item{b_data}{an optional data frame containing the time series of the
state variable values in the baseline.}

\item{comm_d}{a data frame containing long format community data
(species as columns over time as rows) to calculate compositional metrics.}

\item{comm_b}{a data frame containing long format community data (species
names as columns over time as rows) to calculate compositional metrics.}

\item{comm_t}{the name of the time variable in comm_b and comm_d.}

\item{method}{a string identifying the dissimilarity index to be used to
calculate dissimilarity. For more options, see \code{?vegdist}.
Defaults to "bray".}

\item{binary}{a boolean stating whether presence/absence standardization
should be performed before calculating the dissimilarity. For more options,
see \code{?vegdist}. Defaults to "bray".}

\item{low_lim}{minimal dissimilarity value the user expects for a persistent
community}

\item{high_lim}{maximal dissimilarity value the user expects for a persistent
community}

\item{na_rm}{a logical determining whether NAs should be taken out prior
to the estimation of the stability metric. Defaults to TRUE.}
}
\value{
A single numeric value, the persistence,
\eqn{0 \le P \le 1}
. The higher persistence is, the more stable the system.
}
\description{
\code{persistence} ( \eqn{P} ) returns the proportion of time the state
variable remained inside the interval defined by one baseline's
\eqn{\pm}
sd from the baseline's mean (functional stability) or
the user-defined upper and lower limits of the community dissimilarity
(compositional stability). The proportion is calculated in
relation to the time period (\code{metric_tf}) defined by the user.
}
\details{
\deqn{
P = \frac{t_P}{t_a}
}

where
\eqn{t_a}
is the total time frame defined by the
user (\code{metric_tf}) and
\eqn{t_P}
is the time period during which the response remain inside the limits
defined by the user.

If the baseline is defined by the pre-disturbed values of the
state variable in the disturbed system (\code{b = "d"}), this pre-disturbed
time period used as baseline (\code{b_tf}) cannot overlap with the time period
for which the persistence is to be calculated (\code{metric_tf}), because of
redundancy: the values over \code{b_tf} define the interval for which the
values in \code{metric_tf} are checked. If they are the same (or partly, if
overlap is partial), the returned value of persistence will be falsely higher.
}
\examples{
persistence(
  type = "functional", vd_i = "statvar_db", td_i = "time", d_data = aquacomm_resps, b = "d",
  b_tf = c(1, 9), metric_tf = c(28, 56)
)
persistence(
  type = "functional", vd_i = "statvar_db", td_i = "time", d_data = aquacomm_resps, b = "d",
  b_tf = c(1, 9), metric_tf = c(28, 56)
)
persistence(
  type = "functional", vd_i = "statvar_db", td_i = "time", d_data = aquacomm_resps, b = "input",
  metric_tf = c(28, 56), vb_i = "statvar_bl", tb_i = "time",
  b_data = aquacomm_resps
)
persistence(
  type = "functional", vd_i = "statvar_db", td_i = "time", d_data = aquacomm_resps, b = "input",
  metric_tf = c(28, 56), vb_i = "statvar_bl", tb_i = "time",
  b_data = aquacomm_resps
)
persistence(
  type = "compositional", b = "input",metric_tf = c(28, 56), comm_d = comm_dist,
  comm_b = comm_base, comm_t = "time", low_lim = 0.5, high_lim = 0.9
)
}
