% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_getFDSNstation.R
\name{aux_getFDSNstation}
\alias{aux_getFDSNstation}
\title{Query FDSN data base for stations}
\usage{
aux_getFDSNstation(centre, radius, start, access, url)
}
\arguments{
\item{centre}{\code{Numeric} vector of length two, center coordinates 
of the location to search data for (\code{c(latitude, longitude)}). 
Units must be decimal degrees.}

\item{radius}{\code{Numeric} value, radius within which to search for 
seismic stations. Unit must be decimal degrees.}

\item{start}{\code{POSIXct} value, start time of the data to query. If 
omitted, stations are queried for the full time available.}

\item{access}{\code{Logical} value, access type of the data. If omitted,
all data sets are returned, if set \code{TRUE}, only data with access 
flag \code{"open"} are returned.}

\item{url}{\code{Character} vector, optional other FDSN base web 
addresses to search for stations. See details for default addresses and 
their format.}
}
\value{
\code{Data frame} with query results. The data frame contains 
information for all seismic stations fulfilling the defined criteria.
}
\description{
This function queries as series of data bases for seismic stations that 
match a set of criteria for seismic data. The criteria include signal time 
stamp and location, and component. The returned data can be used to 
download data using the function \code{aux_FDSNdata}.
}
\details{
The function requires a working internet connection to perform the query.
It uses the following FDSN data bases by default: 

\itemize{
  \item \code{orfeus} \code{"http://www.orfeus-eu.org"}
  \item \code{geofon} \code{"http://geofon.gfz-potsdam.de/"}
  \item \code{bgr} \code{"http://eida.bgr.de"}
  \item \code{sss} \code{"http://eida.ethz.ch"}
}

Other FDSN data base addresses can be provided in the same way as the 
addresses in the above list. They need to be provided as character 
vector. For a list of addresses see 
\code{"http://www.fdsn.org/webservices/datacenters/"} and 
\code{"http://docs.obspy.org/packages/obspy.clients.fdsn.html#module-obspy.clients.fdsn"}.
}
\examples{

\dontrun{

x <- aux_getFDSNstation(start = as.POSIXct(x = "2010-01-01 22:22:22", 
                                           tz = "UTC"), 
                        centre = c(45, 10), 
                        radius = 1)
                           
## optionally plot station locations on a map (requires RgoogleMaps)
center <- c(mean(x$station_latitude), 
            mean(x$station_longitude))

zoom <- min(RgoogleMaps::MaxZoom(range(x$station_latitude), 
                                 range(x$station_longitude)))
                                 
Map <- RgoogleMaps::GetMap(center = center,
                           zoom = zoom, 
                           maptype = "terrain")
                           
RgoogleMaps::PlotOnStaticMap(MyMap = Map, 
                             lat = x$station_latitude, 
                             lon = x$station_longitude, 
                             pch = 15, 
                             col = 4)
}
                     
}
\seealso{
aux_get_FDSNdata, aux_getIRISstation
}
\author{
Michael Dietze
}
\keyword{eseis}
