% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecgf.R
\name{ecgf}
\alias{ecgf}
\title{Cumulant generating function estimation}
\usage{
ecgf(lambda, X, mix, grad = 0)
}
\arguments{
\item{lambda}{point at which the empirical CGF is evaluated (d-dimensional vector).}

\item{X}{an n by d matrix containing the data.}

\item{mix}{fraction of empirical and normal CGF to use. If \code{mix==1} only the empirical CGF is used, 
if \code{mix==0} only the normal CGF is used.}

\item{grad}{if \code{grad==0} only the value of the CGF at \code{lambda} is returned, 
if \code{grad==1} also its first derivative wrt \code{lambda} 
and \code{if grad==2} also the second derivarive wrt \code{lambda}.}
}
\value{
A list with entries:
        \itemize{
        \item{ \code{K} }{the value of the empirical CGF at \code{lambda};}
        \item{ \code{dK} }{the value of the gradient empirical CGF wrt lambda at \code{lambda};}
        \item{ \code{d2K} }{the value of the hessian of the empirical CGF wrt lambda at \code{lambda}.}
        }
}
\description{
Calculates the empirical cumulant generating function (CGF) and its derivatives
              given a sample of n d-dimentional vectors.
}
\details{
For details on the CGF estimator being used here, see Fasiolo et al. (2016).
}
\examples{
X <- matrix(rnorm(2 * 1e3), 1e3, 2)
K <- ecgf(lambda = c(0, 0), X = X, mix = 0.5, grad = 2) 
K$K # CGF
K$dK # CGF' (gradient)
K$d2K # CGF'' (Hessian)
}
\references{
Fasiolo, M., Wood, S. N., Hartig, F. and Bravington, M. V. (2016). 
            An Extended Empirical Saddlepoint Approximation for Intractable Likelihoods. ArXiv http://arxiv.org/abs/1601.01849.
}
\author{
Matteo Fasiolo <matteo.fasiolo@gmail.com> and Simon N. Wood.
}
