% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_flows.R
\name{get_flows}
\alias{get_flows}
\alias{get_flows.epiflows}
\title{Access flow data}
\usage{
get_flows(x, ...)

\method{get_flows}{epiflows}(x, from = NULL, to = NULL, all = FALSE, ...)
}
\arguments{
\item{x}{An `epiflows` object.}

\item{...}{unused}

\item{from}{a character string defining which regions should be included in the flows}

\item{to}{a character string defining which regions should be included in the flows}

\item{all}{when `TRUE`, all the columns of the flows data frame will be returned. Defaults to `FALSE`, which returns "from", "to", and "n".}
}
\value{
A \code{data.frame} with 3 columns:
\itemize{
\item \code{from}: origin of the flow
\item \code{to}: destination of the flow
\item \code{n}: magnitude of the flow---can be a number of passengers per
unit of time, a rate, a probability of migration
}
}
\description{
This accessor extract flow data from an \code{epiflows}
object. \code{get_flows} is a generic with a method defined for
\code{epiflows} objects.
}
\examples{
data("Brazil_epiflows")
head(get_flows(Brazil_epiflows))
get_flows(Brazil_epiflows, from = "Minas Gerais")
get_flows(Brazil_epiflows, to = "Minas Gerais")
get_flows(Brazil_epiflows, from = "Italy", to = "Minas Gerais")
}
\seealso{
\code{\link[=get_n]{get_n()}};
For location metadata: \code{\link[=get_locations]{get_locations()}}; \code{\link[=get_vars]{get_vars()}}, \code{\link[=get_pop_size]{get_pop_size()}}, \code{\link[=get_coordinates]{get_coordinates()}}
}
\author{
Zhian N. Kamvar
}
