% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_adjust.R
\name{p.adjust}
\alias{p.adjust}
\title{Adjust P-values for Multiple Test Procedures}
\usage{
p.adjust(p, method = "gtxr", n = length(p))
}
\arguments{
\item{p}{vector of p-values.}

\item{method}{multiplicity correction method, "gtxr" is the hybrid Hochberg-Hommel method, "quick" is the Quick method. Other methods include:"holm", "hochberg", "hommel", "bonferroni", "BH", "BY","fdr", "none" from the standard R function p.adjust.}

\item{n}{number of p-values.}
}
\value{
a vector of corrected p-values.
}
\description{
Given a set of p-values, returns adjusted p-values, including the hybrid Hochberg-Hommel procedure (Gou et al., 2014) and Quick procedure (Gou and Zhang, 2022).
}
\details{
Given a set of p-values, returns p-values adjusted using one of several methods. The default method is "gtxr". Another option is "quick". Other adjustment methods have been included in function p.adjust in R package stats.
}
\examples{
library(elitism)
 pvalues.raw <- c(0.002,0.007,0.005,0.024,0.022,0.009,0.007,0.036,0.060,0.035)
 p.adj.hoch <- elitism::p.adjust(pvalues.raw, method = "hochberg")
 p.adj.quick <- elitism::p.adjust(pvalues.raw, method = "quick")
 p.adj.gtxr <- elitism::p.adjust(pvalues.raw, method = "gtxr")
}
\references{
Gou, J., Tamhane, A. C., Xi, D., and Rom, D. (2014). A class of improved hybrid Hochberg-Hommel type step-up multiple test procedures. \emph{Biometrika} \bold{101}, 899-911.

Tamhane, A. C., and Gou, J. (2018). Advances in p-value based multiple test procedures. \emph{Journal of Biopharmaceutical Statistics} \bold{28}, 10-27.

Tamhane, A. C., and Gou, J. (2022). Chapter 2 Multiple test procedures based on p-values. In X. Cui, T. Dickhaus, Y. Ding, and J. C. Hsu (Eds.), \emph{Handbook of multiple comparisons} (Vol. 45, pp. 11-34).

Gou, J.(2022). Quick multiple test procedures and p-value adjustments, \emph{Statistics in Biopharmaceutical Research} \bold{14}, 636-650.
}
\seealso{
\code{stats::p.adjust}
}
\author{
Jiangtao Gou
}
