% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contains.R
\name{contains}
\alias{contains}
\alias{contains.matrix}
\alias{contains.editmatrix}
\alias{contains.editarray}
\alias{contains.cateditmatrix}
\alias{contains.editset}
\title{Determine which edits contain which variable(s)}
\usage{
contains(E, var = NULL, ...)

\method{contains}{matrix}(E, var = NULL, tol = sqrt(.Machine$double.eps), ...)

\method{contains}{editmatrix}(E, var = NULL, tol = sqrt(.Machine$double.eps), ...)

\method{contains}{editarray}(E, var = NULL, ...)

\method{contains}{cateditmatrix}(E, var = NULL, ...)

\method{contains}{editset}(E, var = NULL, ...)
}
\arguments{
\item{E}{\code{\link{editarray}}, \code{\link{editmatrix}}, \code{\link{editset}}, or \code{matrix}}

\item{var}{\code{character}, names of a categorical variables in \code{E}. If var=NULL, all variables are treated.}

\item{...}{arguments to be passed to other methods}

\item{tol}{tolerance to check zero-entries}
}
\value{
\code{logical} vector of length nrow(E), TRUE for edits containing \code{var}
}
\description{
For an \code{\link{editmatrix}}, variables with coefficients smaller than
\code{tol} are considered not to be contained in an edit.
}
\keyword{internal}
