% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity.R
\name{shdi}
\alias{shdi}
\title{Helper function for calculating diversity}
\usage{
shdi(df, stand = NULL, species = NULL, abundance = NULL)
}
\arguments{
\item{df}{A data.frame, which has three cols: stand, species, abundance.
Community matrix should be converted using table2df().}

\item{stand, species, abundance}{A text to specify each column.
If NULL, 1st, 2nd, 3rd column will be used.}
}
\value{
A data.frame.
Including species richness (s), Shannon's H' (h),
Simpson' D (d), Simpson's inverse D (i).
}
\description{
Calculating diversity indices such as species richness (s),
Shannon's H' (h), Simpson' D (d), Simpson's inverse D (i).
}
\examples{
data(dune, package = "vegan")
df <- table2df(dune)
shdi(df)

}
