% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recodeNA2missing.R
\name{recodeNA2missing}
\alias{recodeNA2missing}
\title{Recode \code{NAs} to Missing.}
\usage{
recodeNA2missing(
  GADSdat,
  recodeVars = namesGADS(GADSdat),
  value = -99,
  valLabel = "missing"
)
}
\arguments{
\item{GADSdat}{A \code{GADSdat} object.}

\item{recodeVars}{Character vector of variable names which should be recoded.}

\item{value}{Which value should \code{NAs} be recoded to?}

\item{valLabel}{Which value label should \code{value} be assigned?}
}
\value{
Returns the recoded \code{GADSdat}.
}
\description{
Recode \code{NAs} in multiple variables in a \code{GADSdat} to a numeric value with a value label and a missing tag.
}
\details{
The value label and missing tag are only added to variables which contain \code{NAs} and which have been recoded.
If a variable has an existing value label for \code{value}, the existing value label is overwritten and a missing tag is added.
A corresponding warning is issued.
}
\examples{
# create example GADS
dat <- data.frame(ID = 1:4, age = c(NA, 18, 21, 23),
                  siblings = c(0, 2, NA, NA))
gads <- import_DF(dat)

# recode NAs
gads2 <- recodeNA2missing(gads)
}
