% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skewnessDS2.R
\name{skewnessDS2}
\alias{skewnessDS2}
\title{Calculates the skewness of a numeric variable}
\usage{
skewnessDS2(x, global.mean)
}
\arguments{
\item{x}{a string character, the name of a numeric variable.}

\item{global.mean}{a numeric, the combined mean of the input variable across all studies.}
}
\value{
a list including the sum of cubed differences between the values of x and the global mean of x across
all studies, the sum of squared differences between the values of x and the global mean of x across all studies,
the number of valid observations (i.e. the length of x after excluding missing values), and a validity message 
indicating indicating a valid analysis if the number of valid observations are above the protection filter 
nfilter.tab or invalid analysis otherwise.
}
\description{
This function calculates summary statistics that are returned to the client-side and 
used for the estimation of the combined skewness of a numeric variable across all studies.
}
\details{
The function calculates the sum of squared differences between the values of x and the global
mean of x across all studies, the sum of cubed differences between the values of x and the global mean
of x across all studies and the number of valid observations of the input variable x.
}
\author{
Demetris Avraam, for DataSHIELD Development Team
}
