% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dec_equit.R
\name{dec_equit}
\alias{dec_equit}
\title{Decomposition of the equitability index}
\usage{
dec_equit(x, groups)
}
\arguments{
\item{x}{Vector of dimension S (spicies) with the numbers of observed individuals in each spicy. NA values are allowed. 0 values are converted to NA.}

\item{groups}{Vector of dimension S of factors indicating the groups.}
}
\value{
\itemize{
  \item \code{equitability}: Equitability index.
  \item \code{within}: Within groups equitability.
  \item \code{between}: Between groups equitability.
}
}
\description{
Computes equitability and its decomposition
}
\examples{
data(Qesem_s)
dec_equit(Qesem_s$HU, Qesem_s$Group)

}
\references{
"Arnaud Barat, Andreu Sansó, Maite Arilla-Osuna, Ruth Blasco, Iñaki Pérez-Fernández, Gabriel Cifuentes-Alcobenda, Rubén Llorente, Daniel Vivar-Ríos, Ella Assaf, Ran Barkai, Avi Gopher, & Jordi Rosell-Ardèvol (2025): Quantifying Diversity through Entropy Decomposition. Insights into Hominin Occupation and Carcass Processing  at Qesem cave"

}
\seealso{
\link{dec_shannon}
}
