% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq-color.R
\name{seq_color}
\alias{seq_color}
\title{Interpolate (non-linearly) between two colors}
\usage{
seq_color(
  col1,
  col2,
  n = 100,
  type = "cubic",
  direction = "in-out",
  colorspace = "hcl"
)
}
\arguments{
\item{col1, col2}{the two colors to interpolate between}

\item{n}{Number of steps for the transition (including the endpoints)}

\item{type}{Type of motion easing. Default: 'cubic'.  Valid values are
are 'sine', 'quad', 'cubic', 'quart', 'quint', 'exp', 'circle', 'back',
'elastic', 'linear'.}

\item{direction}{When should the easing apply? Default: "in-out". 
Valid values are 'in', 'out', in-out'. Default: 'in-out'}

\item{colorspace}{Color space in which to do the interpolation. Default: 'hcl'
Can be any colorspace understood by the \code{farver} package i.e.
"cmy", "cmyk", "hsl", "hsb", "hsv", "lab" (CIE L*ab), "hunterlab" 
(Hunter Lab), "oklab", "lch" (CIE Lch(ab) / polarLAB), "luv", "rgb" 
(sRGB), "xyz", "yxy" (CIE xyY), "hcl" (CIE Lch(uv) / polarLuv), 
or "oklch" (Polar form of oklab).
Note: Not all color spaces make sense for interpolation.}
}
\value{
character vector containing a color sequence
}
\description{
Interpolate (non-linearly) between two colors
}
\examples{
\dontshow{if (requireNamespace('farver', quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
n <- 20
cols <- seq_color('red', 'blue', n = n, direction = 'in-out', colorspace = 'hcl')
cols
grid::grid.rect(x = seq(0, 0.95, length.out = n), width = 0.1, 
                gp = grid::gpar(fill = cols, col = NA))
\dontshow{\}) # examplesIf}
}
