% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_haplotypes.R
\name{unique_haplotype_counts}
\alias{unique_haplotype_counts}
\title{List unique haplotypes with their counts}
\usage{
unique_haplotype_counts(x)
}
\arguments{
\item{x}{DataFrame (by locus) of character vectors containing haplotypes (rows) where alleles are separated by comma's, e.g. "13,14.2" is a haplotype}
}
\value{
DataFrame with unique rows and a Count column added at the end
}
\description{
List unique haplotypes with their counts
}
\examples{
# read haplotypes
h <- readxl::read_excel(system.file("extdata","South_Australia.xlsx",
package = "disclapmix2"), 
col_types = "text")[-c(1,2)]

# obtain counts
unique_counts <- disclapmix2::unique_haplotype_counts(h)

# all haplotypes in the dataset are unique
stopifnot(all(unique_counts$Count == 1))
}
