% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile_pr_by_locus_and_cluster.R
\name{profile_pr_by_locus_and_cluster}
\alias{profile_pr_by_locus_and_cluster}
\title{Compute Profile Probability from fit}
\usage{
profile_pr_by_locus_and_cluster(x, fit)
}
\arguments{
\item{x}{DataFrame. Columns should be one character vector for each locus}

\item{fit}{Output from disclapmix2}
}
\value{
Numeric.
}
\description{
Compute the profile probability for a new profile that was not used in the original fit.
}
\examples{
require(disclapmix)

data(danes) 

x <- as.data.frame(sapply(danes[rep(seq_len(nrow(danes)), danes$n), -ncol(danes)], as.character))

dlm2_fit <- disclapmix2(x, number_of_clusters = 3)


new_profile <- structure(list(DYS19 = "14", DYS389I = "13", DYS389II = "29", 
                              DYS390 = "22", DYS391 = "9", DYS392 = "15", DYS393 = "13", 
                              DYS437 = "14", DYS438 = "11", DYS439 = "12"),
                              row.names = 1L, class = "data.frame")

profile_pr_by_locus_and_cluster(x = new_profile, dlm2_fit)
}
