% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{predict}
\alias{predict}
\alias{predict.dgp}
\alias{predict.lgp}
\alias{predict.gp}
\title{Prediction from GP, DGP, or linked (D)GP emulators}
\usage{
\method{predict}{dgp}(
  object,
  x,
  method = "mean_var",
  full_layer = FALSE,
  sample_size = 50,
  M = 50,
  cores = 1,
  chunks = NULL,
  ...
)

\method{predict}{lgp}(
  object,
  x,
  method = "mean_var",
  full_layer = FALSE,
  sample_size = 50,
  M = 50,
  cores = 1,
  chunks = NULL,
  ...
)

\method{predict}{gp}(
  object,
  x,
  method = "mean_var",
  sample_size = 50,
  M = 50,
  cores = 1,
  chunks = NULL,
  ...
)
}
\arguments{
\item{object}{an instance of the \code{gp}, \code{dgp}, or \code{lgp} class.}

\item{x}{the testing input data:
\itemize{
\item if \code{object} is an instance of the \code{gp} or \code{dgp} class, \code{x} is a matrix where each row is an input testing data point and each column is an input dimension.
\item if \code{object} is an instance of the \code{lgp} class, \code{x} must be a matrix representing the global input, where each row corresponds to a test data point and each column represents a global input dimension.
The column indices in \code{x} must align with the indices specified in the \code{From_Output} column of the \code{struc} data frame (used in \code{\link[=lgp]{lgp()}}),
corresponding to rows where the \code{From_Emulator} column is \code{"Global"}.
}}

\item{method}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#updated}{\figure{lifecycle-updated.svg}{options: alt='[Updated]'}}}{\strong{[Updated]}} the prediction approach to use: either the mean-variance approach (\code{"mean_var"}) or the sampling approach (\code{"sampling"}).
The mean-variance approach returns the means and variances of the predictive distributions, while the sampling approach generates samples from predictive distributions
using the derived means and variances. Defaults to \code{"mean_var"}.}

\item{full_layer}{a bool indicating whether to output the predictions of all layers. Defaults to \code{FALSE}. Only used when \code{object} is a DGP or a linked (D)GP emulator.}

\item{sample_size}{the number of samples to draw for each given imputation if \code{method = "sampling"}. Defaults to \code{50}.}

\item{M}{the size of the conditioning set for the Vecchia approximation in the emulator prediction. Defaults to \code{50}. This argument is only used if the emulator \code{object}
was constructed under the Vecchia approximation.}

\item{cores}{the number of processes to be used for prediction. If set to \code{NULL}, the number of processes is set to \verb{max physical cores available \%/\% 2}. Defaults to \code{1}.}

\item{chunks}{the number of chunks that the testing input matrix \code{x} will be divided into for multi-cores to work on.
Only used when \code{cores} is not \code{1}. If not specified (i.e., \code{chunks = NULL}), the number of chunks is set to the value of \code{cores}.
Defaults to \code{NULL}.}

\item{...}{N/A.}
}
\value{
\itemize{
\item If \code{object} is an instance of the \code{gp} class:
\enumerate{
\item if \code{method = "mean_var"}: an updated \code{object} is returned with an additional slot called \code{results} that contains two matrices named \code{mean}
for the predictive means and \code{var} for the predictive variances. Each matrix has only one column with its rows
corresponding to testing positions (i.e., rows of \code{x}).
\item if \code{method = "sampling"}: an updated \code{object} is returned with an additional slot called \code{results} that contains a matrix whose rows correspond
to testing positions and columns correspond to \code{sample_size} number of samples drawn from the predictive distribution of GP.
}
\item \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#updated}{\figure{lifecycle-updated.svg}{options: alt='[Updated]'}}}{\strong{[Updated]}} If \code{object} is an instance of the \code{dgp} class:
\enumerate{
\item if \code{method = "mean_var"} and  \code{full_layer = FALSE}: an updated \code{object} is returned with an additional slot called \code{results} that contains two
matrices named \code{mean} for the predictive means and \code{var} for the predictive variances respectively. Each matrix has its rows corresponding to testing
positions and columns corresponding to DGP global output dimensions (i.e., the number of GP/likelihood nodes in the final layer). If the likelihood node
is categorical, the matrices contain the predictive means and variances of the class probabilities, with columns corresponding to different classes.
\item if \code{method = "mean_var"} and  \code{full_layer = TRUE}: an updated \code{object} is returned with an additional slot called \code{results} that contains two
sub-lists named \code{mean} for the predictive means and \code{var} for the predictive variances respectively. Each sub-list contains \emph{L} (i.e., the number of layers)
matrices named \verb{layer1, layer2,..., layerL}. Each matrix has its rows corresponding to testing positions and columns corresponding to
output dimensions (i.e., the number of GP/likelihood nodes from the associated layer). If the likelihood node is categorical, the matrices named \code{layerL}
in both \code{mean} and \code{var} contain the predictive means and variances of the class probabilities, respectively, with columns corresponding to different classes.
\item if \code{method = "sampling"} and  \code{full_layer = FALSE}: an updated \code{object} is returned with an additional slot called \code{results} that contains \emph{D} (i.e., the number
of GP/likelihood nodes in the final layer) matrices named \verb{output1, output2,..., outputD}. If the likelihood node in the final layer is categorical, \code{results}
contains \emph{D} matrices (where \emph{D} is the number of classes) of sampled class probabilities, each named according to its corresponding class label. Each matrix in \code{results}
has its rows corresponding to testing positions and columns corresponding to samples of size: \code{B * sample_size}, where \code{B} is the number of imputations specified in \code{\link[=dgp]{dgp()}}.
\item if \code{method = "sampling"} and  \code{full_layer = TRUE}: an updated \code{object} is returned with an additional slot called \code{results} that contains \emph{L} (i.e., the number
of layers) sub-lists named \verb{layer1, layer2,..., layerL}. Each sub-list represents samples drawn from the GP/likelihood nodes in the corresponding layer,
and contains \emph{D} (i.e., the number of GP/likelihood nodes in the corresponding layer) matrices named \verb{output1, output2,..., outputD}. If the likelihood node in the final
layer is categorical, \code{layerL} contains \emph{D} matrices (where \emph{D} is the number of classes) of sampled class probabilities, each named according to its corresponding class
label. Each matrix has its rows corresponding to testing positions and columns corresponding to samples
of size: \code{B * sample_size}, where \code{B} is the number of imputations specified in \code{\link[=dgp]{dgp()}}.
}
\item If \code{object} is an instance of the \code{lgp} class:
\enumerate{
\item if \code{method = "mean_var"} and  \code{full_layer = FALSE}: an updated \code{object} is returned with an additional slot called \code{results} that
contains two sub-lists named \code{mean} for the predictive means and \code{var} for the predictive variances respectively. Each sub-list
contains \emph{K} (same number of emulators in the final layer of the system) matrices named using the \code{ID}s of the corresponding emulators in the final layer.
Each matrix has rows corresponding to global testing positions and columns corresponding to output dimensions of the associated emulator
in the final layer.
\item if \code{method = "mean_var"} and  \code{full_layer = TRUE}: an updated \code{object} is returned with an additional slot called \code{results} that contains
two sub-lists named \code{mean} for the predictive means and \code{var} for the predictive variances respectively. Each sub-list contains \emph{L}
(i.e., the number of layers in the emulated system) components named \verb{layer1, layer2,..., layerL}. Each component represents a layer
and contains \emph{K} (same number of emulators in the corresponding layer of the system) matrices named using the \code{ID}s of the corresponding emulators in that layer.
Each matrix has its rows corresponding to global testing positions and columns corresponding to output dimensions of the associated
GP/DGP emulator in the corresponding layer.
\item if \code{method = "sampling"} and  \code{full_layer = FALSE}: an updated \code{object} is returned with an additional slot called \code{results} that contains
\emph{K} (same number of emulators in the final layer of the system) sub-lists named using the \code{ID}s of the corresponding emulators in the final layer. Each
sub-list contains \emph{D} matrices, named \verb{output1, output2,..., outputD}, that correspond to the output
dimensions of the GP/DGP emulator. Each matrix has rows corresponding to testing positions and columns corresponding to samples
of size: \code{B * sample_size}, where \code{B} is the number of imputations specified in \code{\link[=lgp]{lgp()}}.
\item if \code{method = "sampling"} and  \code{full_layer = TRUE}: an updated \code{object} is returned with an additional slot called \code{results} that contains
\emph{L} (i.e., the number of layers of the emulated system) sub-lists named \verb{layer1, layer2,..., layerL}. Each sub-list represents a layer
and contains \emph{K} (same number of emulators in the corresponding layer of the system) components named using the \code{ID}s of the corresponding emulators in that layer.
Each component contains \emph{D} matrices, named \verb{output1, output2,..., outputD}, that correspond to
the output dimensions of the GP/DGP emulator. Each matrix has its rows corresponding to testing positions and columns corresponding to
samples of size: \code{B * sample_size}, where \code{B} is the number of imputations specified in \code{\link[=lgp]{lgp()}}.
}
}

The \code{results} slot will also include:
\itemize{
\item the value of \code{M}, which represents the size of the conditioning set for the Vecchia approximation, if used, in the emulator prediction.
\item the value of \code{sample_size} if \code{method = "sampling"}.
}
}
\description{
This function implements prediction from GP, DGP, or linked (D)GP emulators.
}
\details{
See further examples and tutorials at \url{https://mingdeyu.github.io/dgpsi-R/}.
}
\examples{
\dontrun{

# See gp(), dgp(), or lgp() for an example.
}
}
