% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretty.R
\name{pretty_num_table}
\alias{pretty_num_table}
\title{Format a data frame with \code{dfeR::pretty_num()}.}
\usage{
pretty_num_table(data, include_columns = NULL, exclude_columns = NULL, ...)
}
\arguments{
\item{data}{A data frame containing the columns to be formatted.}

\item{include_columns}{A character vector specifying which columns to format.
If \code{NULL} (default), all columns will be considered for formatting.}

\item{exclude_columns}{A character vector specifying columns to exclude
from formatting.
If \code{NULL} (default), no columns will be excluded.
If both \code{include_columns} and \code{exclude_columns} are provided
, \code{include_columns} takes precedence.}

\item{...}{Additional arguments passed to \code{dfeR::pretty_num()}
, such as \code{dp} (decimal places)
for controlling the number of decimal points.}
}
\value{
A data frame with columns formatted using \code{dfeR::pretty_num()}.
}
\description{
You can format number and character values in a data frame
by passing arguments to \code{dfeR::pretty_num()}.
Use parameters \code{include_columns} or \code{exclude_columns}
to specify columns for formatting.
}
\details{
The function first checks if any columns are specified for inclusion
via \code{include_columns}.
If none are provided, it checks if columns are specified for exclusion
via \code{exclude_columns}.
If neither is specified, all columns in the data frame are formatted.
}
\examples{
# Example data frame
df <- data.frame(
  a = c(1.234, 5.678, 9.1011),
  b = c(10.1112, 20.1314, 30.1516),
  c = c("A", "B", "C")
)

# Apply formatting to all columns
pretty_num_table(df, dp = 2)

# Apply formatting to only selected columns
pretty_num_table(df, include_columns = c("a"), dp = 2)

# Apply formatting to all columns except specified ones
pretty_num_table(df, exclude_columns = c("b"), dp = 2)

# Apply formatting to all columns except specified ones and
# provide alternative value for NAs
pretty_num_table(df, alt_na = "[z]", exclude_columns = c("b"), dp = 2)

}
\seealso{
\code{\link[=pretty_num]{pretty_num()}}

Other prettying: 
\code{\link{pretty_filesize}()},
\code{\link{pretty_num}()},
\code{\link{pretty_time_taken}()}
}
\concept{prettying}
