% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sigma_fun.R
\name{Sigma_fun}
\alias{Sigma_fun}
\title{Variance-covariance of sample central moments (root-n approximation)
given the vector mu with the theoretical moments of order 1 to 8.
CAREFUL: the result must be divided by n (= sample size)!}
\usage{
Sigma_fun(mu)
}
\arguments{
\item{mu}{Vector of length 8 with the first 8 theoretical central moments.}
}
\value{
Variance-covariance matrix of the first four sample central moments (CAREFUL: a division by the sample size is further required !)
}
\description{
Variance-covariance of sample central moments (root-n approximation)
given the vector mu with the theoretical moments of order 1 to 8.
CAREFUL: the result must be divided by n (= sample size)!
}
\examples{
mu = numeric(8)
dfun = function(x) dgamma(x,10,5)
mu[1] = integrate(function(x) x*dfun(x),0,Inf)$val
for (j in 2:8) mu[j] = integrate(function(x) (x-mu[1])^j*dfun(x),0,Inf)$val
Sigma_fun(mu)

}
\references{
Lambert, P. (2021) Moment-based density and risk estimation from grouped summary statistics. arXiv:2107.03883.
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
