% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CI_mc.R
\name{CI_mc}
\alias{CI_mc}
\title{compute the confidence intervals (CIs) from the de-biased estimator}
\usage{
CI_mc(i, j, alpha = 0.05, missfrac, X.db, est_rank, sigma2 = 1)
}
\arguments{
\item{i}{the row index of the interest entry X_{i,j}}

\item{j}{the row index of the interest entry X_{i,j}}

\item{alpha}{confidence level, default is 0.05}

\item{missfrac}{the missing proportion in the underlying matrix.
It is the total of missing entries over total entries.}

\item{X.db}{the de-biased estimated matrix from the 'dbmc' function.}

\item{est_rank}{the (estimated) low-rank of the underlying matrix or the rank of the de-biased estimator.}

\item{sigma2}{the noise-variance level.}
}
\value{
CI confidence interval.

(i,j) the location of the entry at i-th row and j-th column.

v.ij the estimated variance of the limiting Gaussian distribution.
}
\description{
This function returns a CI for an entries of interest with a significant level alpha
}
\references{
Chen et al (2019). Inference and uncertainty quantification for noisy matrix completion. PNAS, 116(46), 22931-22937.
}
