% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareConnection.R
\name{prepareConnection}
\alias{prepareConnection}
\title{Prepares connection to RDBS via ODBC}
\usage{
prepareConnection(db.vendor, odbc.driver = odbc::odbc(),
  db.host = NULL, db.name = NULL, db.encoding = "", dsn = NULL,
  user = NULL, passwd = NULL)
}
\arguments{
\item{db.vendor}{Database vendor (teradata, sqlserver)}

\item{odbc.driver}{ODBC driver used to connect to database}

\item{db.host}{Database hostname}

\item{db.name}{Database name}

\item{db.encoding}{Database encoding}

\item{dsn}{Data source name}

\item{user}{Username to connect to database}

\item{passwd}{Password to connect to database}
}
\description{
\code{prepareConnection} list connection details needed to connecto
to a RDBS using ODBC
}
\examples{
conn.info <- prepareConnection(db.vendor = "teradata",
   dsn = "ODBC_MYDB", user = "myuser", passwd = "mypasswd")
}
